import wx
import gettext

from utils.common.enums import ProcessingType

from gui.component.window.dialog import Dialog

_ = gettext.gettext

class ProcessingWindow(Dialog):
    def __init__(self, parent):
        Dialog.__init__(self, parent, _("解析中"), style = wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP, name = "processing")

        self.EnableCloseButton(False)
        
        self.init_UI()
        
        self.CenterOnParent()
        
    def init_UI(self):
        self.processing_label = wx.StaticText(self, -1, _("正在解析中，请稍候"))
        self.name_lab = wx.StaticText(self, -1, "")
        self.node_title_label = wx.StaticText(self, -1, _("节点：--"))

        self.cancel_btn = wx.Button(self, -1, _("取消"), size = self.get_scaled_size((60, 24)))
        self.cancel_btn.Enable(False)

        btn_hbox = wx.BoxSizer(wx.HORIZONTAL)
        btn_hbox.AddStretchSpacer()
        btn_hbox.Add(self.cancel_btn, 0, wx.ALL & (~wx.TOP), self.FromDIP(6))
        btn_hbox.AddStretchSpacer()

        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(self.processing_label, 0, wx.ALL, self.FromDIP(6))
        vbox.Add(self.name_lab, 0, wx.ALL & (~wx.TOP), self.FromDIP(6))
        vbox.Add(self.node_title_label, 0, wx.ALL & (~wx.TOP), self.FromDIP(6))
        vbox.Add(btn_hbox, 0, wx.EXPAND)

        self.SetSizer(vbox)
    
    def UpdateName(self, name: str):
        def worker():
            self.name_lab.SetLabel(name)

            self.Layout()
        
        wx.CallAfter(worker)

    def UpdateTitle(self, title: str):
        def worker():
            self.node_title_label.SetLabel(title)

            self.Layout()
        
        wx.CallAfter(worker)

    def ShowModal(self, type: ProcessingType):
        self.SetType(type)

        self.reset()

        return super().ShowModal()
    
    def SetType(self, type: ProcessingType):
        def worker():
            self.SetTitle(title)
            self.processing_label.SetLabel(tip)

            self.name_lab.Show(title_show)
            self.node_title_label.Show(title_show)

            self.Layout()

        match type:
            case ProcessingType.Process:
                title = _("处理中")
                tip = _("正在处理中，请稍候")
                title_show = False

            case ProcessingType.Parse:
                title = _("解析中")
                tip = _("正在解析中，请稍候")
                title_show = False

            case ProcessingType.Interact:
                title = _("互动视频")
                tip = _("正在探查所有节点，请稍候")
                title_show = True

            case ProcessingType.Page:
                title = _("解析中")
                tip = _("正在获取所有分页数据，请稍候")
                title_show = True

        wx.CallAfter(worker)

    def Layout(self):
        super().Layout()

        self.Fit()

        self.CenterOnParent()

    def reset(self):
        self.name_lab.SetLabel("")
        self.node_title_label.SetLabel(_("节点：--"))